/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.dhcp.model.transform;

import com.nifty.cloud.sdk.dhcp.model.DhcpConfig;
import com.nifty.cloud.sdk.dhcp.model.transform.IpAddressPoolSetConverter;
import com.nifty.cloud.sdk.dhcp.model.transform.StaticMappingsSetConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.List;

public class DhcpConfigConverter
implements Converter {
    private static final String ELEMENT_DHCP_CONFIG_ID = "dhcpConfigId";
    private static final String ELEMENT_IP_ADDRESS_POOLS_SET = "ipAddressPoolsSet";
    private static final String ELEMENT_STATIC_MAPPINGS_SET = "staticMappingsSet";

    public boolean canConvert(Class clazz) {
        return clazz == DhcpConfig.class;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        DhcpConfig dhcpConfig = new DhcpConfig();
        IpAddressPoolSetConverter ipAddressPoolSetConverter = new IpAddressPoolSetConverter();
        StaticMappingsSetConverter staticMappingsSetConverter = new StaticMappingsSetConverter();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            name = reader.getNodeName();
            if (name.equals(ELEMENT_DHCP_CONFIG_ID)) {
                dhcpConfig.setDhcpConfigId(reader.getValue());
            } else if (name.equals(ELEMENT_IP_ADDRESS_POOLS_SET)) {
                dhcpConfig.setIpAddressPools((List)ipAddressPoolSetConverter.unmarshal(reader, context));
            } else if (name.equals(ELEMENT_STATIC_MAPPINGS_SET)) {
                dhcpConfig.setStaticMappings((List)staticMappingsSetConverter.unmarshal(reader, context));
            }
            reader.moveUp();
        }
        return dhcpConfig;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

