/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.dhcp.model;

import com.nifty.cloud.sdk.annotation.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DhcpConfiguration {
    private String key;
    private List<String> values;

    @Query(name="Key", require=true)
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public DhcpConfiguration withKey(String key) {
        this.setKey(key);
        return this;
    }

    @Query(name="Value", require=true)
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public DhcpConfiguration withValues(String ... values) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String value : values) {
            this.getValues().add(value);
        }
        return this;
    }

    public DhcpConfiguration withValues(Collection<String> values) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        if (values != null) {
            this.getValues().addAll(values);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[key=");
        builder.append(this.key);
        builder.append(", values=");
        builder.append(this.values);
        builder.append("]");
        return builder.toString();
    }
}

