/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.dhcp.model;

import com.nifty.cloud.sdk.dhcp.model.IpAddressPool;
import com.nifty.cloud.sdk.dhcp.model.StaticMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DhcpConfig {
    private String dhcpConfigId;
    private List<IpAddressPool> ipAddressPools;
    private List<StaticMapping> staticMappings;

    public String getDhcpConfigId() {
        return this.dhcpConfigId;
    }

    public void setDhcpConfigId(String dhcpConfigId) {
        this.dhcpConfigId = dhcpConfigId;
    }

    public DhcpConfig withDhcpConfigId(String dhcpConfigId) {
        this.setDhcpConfigId(dhcpConfigId);
        return this;
    }

    public List<IpAddressPool> getIpAddressPools() {
        return this.ipAddressPools;
    }

    public void setIpAddressPools(List<IpAddressPool> ipAddressPools) {
        this.ipAddressPools = ipAddressPools;
    }

    public DhcpConfig withIpAddressPools(IpAddressPool ... ipAddressPools) {
        if (this.ipAddressPools == null) {
            this.ipAddressPools = new ArrayList<IpAddressPool>();
        }
        for (IpAddressPool ipAddressPool : ipAddressPools) {
            this.getIpAddressPools().add(ipAddressPool);
        }
        return this;
    }

    public DhcpConfig withIpAddressPools(Collection<IpAddressPool> ipAddressPools) {
        if (this.ipAddressPools == null) {
            this.ipAddressPools = new ArrayList<IpAddressPool>();
        }
        if (ipAddressPools != null) {
            this.getIpAddressPools().addAll(ipAddressPools);
        }
        return this;
    }

    public List<StaticMapping> getStaticMappings() {
        return this.staticMappings;
    }

    public void setStaticMappings(List<StaticMapping> staticMappings) {
        this.staticMappings = staticMappings;
    }

    public DhcpConfig withStaticMappings(StaticMapping ... staticMappings) {
        if (this.staticMappings == null) {
            this.staticMappings = new ArrayList<StaticMapping>();
        }
        for (StaticMapping staticMapping : staticMappings) {
            this.getStaticMappings().add(staticMapping);
        }
        return this;
    }

    public DhcpConfig withStaticMappings(Collection<StaticMapping> staticMappings) {
        if (this.staticMappings == null) {
            this.staticMappings = new ArrayList<StaticMapping>();
        }
        if (staticMappings != null) {
            this.getStaticMappings().addAll(staticMappings);
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[dhcpConfigId=");
        builder.append(this.dhcpConfigId);
        builder.append(", ipAddressPools=");
        builder.append(this.ipAddressPools);
        builder.append(", staticMappings=");
        builder.append(this.staticMappings);
        builder.append("]");
        return builder.toString();
    }
}

