/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.auth;

import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.tools.QueryStringGenarator;
import java.net.MalformedURLException;
import java.net.URL;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public final class SignatureUtils {
    public static String caluculateSignature(SignatureVersion version, SignatureMethod method, String secretAccessKey, String httpVerb, String url, QueryStringGenarator query) {
        SignatureMethod signatureMethod = SignatureMethod.HmacSHA1;
        try {
            String sign = null;
            switch (version) {
                case Version_2: {
                    signatureMethod = method;
                    sign = SignatureUtils.version2Sign(httpVerb, url, query);
                    break;
                }
                default: {
                    throw new NiftyClientException("Unknown Signature Version.");
                }
            }
            Mac mac = Mac.getInstance(signatureMethod.getAlgorithm());
            mac.init(new SecretKeySpec(secretAccessKey.getBytes("UTF-8"), signatureMethod.getAlgorithm()));
            byte[] signature = mac.doFinal(sign.getBytes("UTF-8"));
            return new String(Base64.encodeBase64((byte[])signature));
        }
        catch (Exception e) {
            throw new NiftyClientException(e);
        }
    }

    private static String version2Sign(String httpVerb, String url, QueryStringGenarator query) throws MalformedURLException {
        URL getUrl = new URL(url);
        StringBuilder sign = new StringBuilder();
        sign.append(httpVerb).append("\n").append(SignatureUtils.getHost(url)).append("\n").append(QueryStringGenarator.urlEncode(getUrl.getPath(), true, true)).append("\n").append(query.toQueryString(true));
        return sign.toString();
    }

    private static String getHost(String url) throws MalformedURLException {
        return new URL(url.toLowerCase()).getHost();
    }

    public static enum SignatureMethod {
        HmacSHA1("HmacSHA1"),
        HmacSHA256("HmacSHA256");

        private String algorithm;

        private SignatureMethod(String algorithm) {
            this.algorithm = algorithm;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public static SignatureMethod find(String algorithm) {
            if (HmacSHA1.getAlgorithm().equals(algorithm)) {
                return HmacSHA1;
            }
            if (HmacSHA256.getAlgorithm().equals(algorithm)) {
                return HmacSHA256;
            }
            throw new NiftyClientException("Unsupported Signature method.");
        }
    }

    public static enum SignatureVersion {
        Version_0("0"),
        Version_1("1"),
        Version_2("2");

        private String value;

        private SignatureVersion(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SignatureVersion find(String value) {
            if (Version_0.getValue().equals(value)) {
                return Version_0;
            }
            if (Version_1.getValue().equals(value)) {
                return Version_1;
            }
            if (Version_2.getValue().equals(value)) {
                return Version_2;
            }
            throw new NiftyClientException("Unsupported Signature version.");
        }
    }
}

