/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.auth;

import com.nifty.cloud.sdk.auth.Credentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesCredentials
implements Credentials {
    private String accessKeyId;
    private String secretKey;

    public PropertiesCredentials(File file) throws IOException {
        this(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesCredentials(InputStream is) throws IOException {
        Properties props = new Properties();
        try {
            props.load(is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        this.accessKeyId = props.getProperty("accessKey");
        this.secretKey = props.getProperty("secretKey");
        if (this.accessKeyId == null || this.accessKeyId.isEmpty() || this.secretKey == null || this.secretKey.isEmpty()) {
            throw new IllegalArgumentException("Not exists access key id and secret key Credential file");
        }
    }

    @Override
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    @Override
    public String getSecretKey() {
        return this.secretKey;
    }
}

