/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.address.model.transform;

import com.nifty.cloud.sdk.address.model.Address;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class AddressConverter
implements Converter {
    private static final String ELEMENT_PUBLIC_IP = "publicIp";
    private static final String ELEMENT_PRIVATE_IP_ADDRESS = "privateIpAddress";
    private static final String ELEMENT_ALLOCATION_ID = "allocationId";
    private static final String ELEMENT_DOMAIN = "domain";
    private static final String ELEMENT_INSTANCE_ID = "instanceId";
    private static final String ELEMENT_ASSOCIATION_ID = "associationId";
    private static final String ELEMENT_NETWORK_INTERFACE_ID = "networkInterfaceId";
    private static final String ELEMENT_NETWORK_INTERFACE_OWNER_ID = "networkInterfaceOwnerId";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_AVAILABILITY_ZONE = "availabilityZone";

    public boolean canConvert(Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Address address = new Address();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_PUBLIC_IP)) {
                    address.setPublicIp(reader.getValue());
                } else if (name.equals(ELEMENT_PRIVATE_IP_ADDRESS)) {
                    address.setPrivateIpAddress(reader.getValue());
                } else if (name.equals(ELEMENT_ALLOCATION_ID)) {
                    address.setAllocationId(reader.getValue());
                } else if (name.equals(ELEMENT_DOMAIN)) {
                    address.setDomain(reader.getValue());
                } else if (name.equals(ELEMENT_INSTANCE_ID)) {
                    address.setInstanceId(reader.getValue());
                } else if (name.equals(ELEMENT_ASSOCIATION_ID)) {
                    address.setAssociationId(reader.getValue());
                } else if (name.equals(ELEMENT_NETWORK_INTERFACE_ID)) {
                    address.setNetworkInterfaceId(reader.getValue());
                } else if (name.equals(ELEMENT_NETWORK_INTERFACE_OWNER_ID)) {
                    address.setNetworkInterfaceOwnerId(reader.getValue());
                } else if (name.equals(ELEMENT_DESCRIPTION)) {
                    address.setDescription(reader.getValue());
                } else if (name.equals(ELEMENT_AVAILABILITY_ZONE)) {
                    address.setAvailabilityZone(reader.getValue());
                }
                reader.moveUp();
            }
            addresses.add(address);
            reader.moveUp();
        }
        return addresses;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

