/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk;

import com.nifty.cloud.sdk.NiftyClientException;
import com.nifty.cloud.sdk.Protocol;
import com.nifty.cloud.sdk.auth.SignatureUtils;
import java.util.ResourceBundle;

public class ClientConfiguration {
    private String userAgent = "NIFCLOUD API Java SDK";
    private Protocol protocol = Protocol.find("https");
    private String proxyHost = null;
    private int proxyPort = 0;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private int maxErrorRetry = 3;
    private int maxConnections = 50;
    private int socketTimeout = 300;
    private int connectionTimeout = 300;
    private int socketSendBufferSizeHint = 0;
    private int socketReceiveBufferSizeHint = 0;
    private SignatureUtils.SignatureVersion signatureVersion = SignatureUtils.SignatureVersion.find("2");
    private SignatureUtils.SignatureMethod signatureMethod = SignatureUtils.SignatureMethod.find("HmacSHA256");
    private String configEndpoint = null;
    private String configUploadEndpoint = null;
    private String requestMethod = "GET";
    private int uploadBlockSize = 8;
    private Boolean sslTrustSelfSigned = false;
    private Boolean sslVerifyHostname = true;

    public ClientConfiguration() {
        this("nifty_cloud-sdk");
    }

    public ClientConfiguration(String propertiesFile) {
        ResourceBundle bundle = ResourceBundle.getBundle(propertiesFile);
        String value = this.getResourceValue(bundle, "nifty_cloud.sdk.user_agent");
        if (value != null && !value.isEmpty()) {
            this.userAgent = value;
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.protocol")) != null && !value.isEmpty()) {
            this.protocol = Protocol.find(value);
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.proxy_host")) != null && !value.isEmpty()) {
            this.proxyHost = value;
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.proxy_port")) != null && !value.isEmpty()) {
            this.proxyPort = Integer.parseInt(value);
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.proxy_username")) != null && !value.isEmpty()) {
            this.proxyUsername = value;
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.proxy_password")) != null && !value.isEmpty()) {
            this.proxyPassword = value;
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.max_error_retry")) != null && !value.isEmpty()) {
            this.maxErrorRetry = Integer.parseInt(value);
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.max_connections")) != null && !value.isEmpty()) {
            this.maxConnections = Integer.parseInt(value);
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.so_timeout")) != null && !value.isEmpty()) {
            this.socketTimeout = Integer.parseInt(value);
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.connection_timeout")) != null && !value.isEmpty()) {
            this.connectionTimeout = Integer.parseInt(value);
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.socket_send_buffer_size_hint")) != null && !value.isEmpty()) {
            this.socketSendBufferSizeHint = Integer.parseInt(value);
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.socket_receive_buffer_size_hint")) != null && !value.isEmpty()) {
            this.socketReceiveBufferSizeHint = Integer.parseInt(value);
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.signature_version")) != null && !value.isEmpty()) {
            this.signatureVersion = SignatureUtils.SignatureVersion.find(value);
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.signature_method")) != null && !value.isEmpty()) {
            this.signatureMethod = SignatureUtils.SignatureMethod.find(value);
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.url")) != null && !value.isEmpty()) {
            this.configEndpoint = value;
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.upload_url")) != null && !value.isEmpty()) {
            this.configUploadEndpoint = value;
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.request_method")) != null && !value.isEmpty()) {
            if (value.equalsIgnoreCase("GET") || value.equalsIgnoreCase("POST")) {
                this.requestMethod = value;
            } else {
                throw new NiftyClientException("Unsupported request method.");
            }
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.upload_block_size")) != null && !value.isEmpty()) {
            this.uploadBlockSize = Integer.parseInt(value);
        }
        if (System.getProperty("http.proxyHost") != null) {
            this.proxyHost = System.getProperty("http.proxyHost");
        }
        if (System.getProperty("http.proxyPort") != null) {
            this.proxyPort = Integer.parseInt(System.getProperty("http.proxyPort"));
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.ssl_trust_self_signed")) != null && !value.isEmpty()) {
            this.sslTrustSelfSigned = Boolean.valueOf(value);
        }
        if ((value = this.getResourceValue(bundle, "nifty_cloud.sdk.ssl_verify_hostname")) != null && !value.isEmpty()) {
            this.sslVerifyHostname = Boolean.valueOf(value);
        }
    }

    private String getResourceValue(ResourceBundle bundle, String key) {
        if (key == null) {
            return null;
        }
        return bundle.containsKey(key) ? bundle.getString(key) : null;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public ClientConfiguration withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public ClientConfiguration withProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public ClientConfiguration withProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public ClientConfiguration withProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public ClientConfiguration withProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return this;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public ClientConfiguration withProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public void setMaxErrorRetry(int maxErrorRetry) {
        this.maxErrorRetry = maxErrorRetry;
    }

    public ClientConfiguration withMaxErrorRetry(int maxErrorRetry) {
        this.maxErrorRetry = maxErrorRetry;
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public ClientConfiguration withMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public ClientConfiguration withSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public ClientConfiguration withConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public int[] getSocketBufferSizeHints() {
        return new int[]{this.socketSendBufferSizeHint, this.socketReceiveBufferSizeHint};
    }

    public void setSocketSendBufferSizeHint(int socketSendBufferSizeHint, int socketReceiveBufferSizeHint) {
        this.socketSendBufferSizeHint = socketSendBufferSizeHint;
        this.socketReceiveBufferSizeHint = socketReceiveBufferSizeHint;
    }

    public ClientConfiguration withSocketSendBufferSizeHint(int socketSendBufferSizeHint, int socketReceiveBufferSizeHint) {
        this.socketSendBufferSizeHint = socketSendBufferSizeHint;
        this.socketReceiveBufferSizeHint = socketReceiveBufferSizeHint;
        return this;
    }

    public SignatureUtils.SignatureVersion getSignatureVersion() {
        return this.signatureVersion;
    }

    public void setSignatureVersion(SignatureUtils.SignatureVersion signatureVersion) {
        this.signatureVersion = signatureVersion;
    }

    public ClientConfiguration withSignatureVersion(SignatureUtils.SignatureVersion signatureVersion) {
        this.signatureVersion = signatureVersion;
        return this;
    }

    public SignatureUtils.SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(SignatureUtils.SignatureMethod signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public ClientConfiguration withSignatureMethod(SignatureUtils.SignatureMethod signatureMethod) {
        this.signatureMethod = signatureMethod;
        return this;
    }

    public String getConfigEndpoint() {
        return this.configEndpoint;
    }

    public void setConfigEndpoint(String configEndpoint) {
        this.configEndpoint = configEndpoint;
    }

    public ClientConfiguration withConfigEndpoint(String configEndpoint) {
        this.configEndpoint = configEndpoint;
        return this;
    }

    public String getConfigUploadEndpoint() {
        return this.configUploadEndpoint;
    }

    public void setConfigUploadEndpoint(String configUploadEndpoint) {
        this.configUploadEndpoint = configUploadEndpoint;
    }

    public ClientConfiguration withConfigUploadEndpoint(String configUploadEndpoint) {
        this.configUploadEndpoint = configUploadEndpoint;
        return this;
    }

    public int getUploadBlockSize() {
        return this.uploadBlockSize;
    }

    public void setUploadBlockSize(int uploadBlockSize) {
        this.uploadBlockSize = uploadBlockSize;
    }

    public ClientConfiguration withUploadBlockSize(int uploadBlockSize) {
        this.setUploadBlockSize(uploadBlockSize);
        return this;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public ClientConfiguration withRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public Boolean getSslTrustSelfSigned() {
        return this.sslTrustSelfSigned;
    }

    public Boolean getSslVerifyHostname() {
        return this.sslVerifyHostname;
    }
}

