<?php
namespace Aws\Sqs;

use Aws\Sqs\Exception\SqsException;
use Guzzle\Common\Event;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Listener used to change to upper case of the QueueOwnerNIFTYAccountId in GetQueueUrl
 */
class UpperCaseValidatorListener implements EventSubscriberInterface
{

    /**
     * {@inheritdoc}
     */
    public static function getSubscribedEvents()
    {
        return array('command.before_send' => array('onCommandBeforeSend', -255));
    }

    /**
     * Updates the QueueOwnerNIFTYAccountId to upper case
     *
     * @param Event $event Event emitted
     */
    public function onCommandBeforeSend(Event $event)
    {
        /** @var $command AbstractCommand */
        $command = $event['command'];
        if ($command->hasKey('QueueOwnerNIFTYAccountId')) {
            $request = $command->getRequest();
	    $queueOwnerNIFTYAccountId = strtolower($command->get('QueueOwnerNIFTYAccountId'));
	    $request->setPostField('QueueOwnerNIFTYAccountId', $queueOwnerNIFTYAccountId);
        }
    }
}
