package sslcertificate

import (
	"context"
	"fmt"

	"github.com/hashicorp/terraform-plugin-sdk/v2/diag"
	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
	"github.com/nifcloud/terraform-provider-nifcloud/nifcloud/client"
)

func update(ctx context.Context, d *schema.ResourceData, meta interface{}) diag.Diagnostics {
	svc := meta.(*client.Client).Computing

	if d.HasChange("description") {
		input := expandModifySSLCertificateAttributeInput(d)

		_, err := svc.ModifySslCertificateAttribute(ctx, input)
		if err != nil {
			return diag.FromErr(fmt.Errorf("failed updating SSLCertificate description: %s", err.Error()))
		}
	}

	return read(ctx, d, meta)
}
