package nassecuritygroup

import (
	"context"
	"fmt"

	"github.com/hashicorp/terraform-plugin-sdk/v2/diag"
	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
	"github.com/nifcloud/terraform-provider-nifcloud/nifcloud/client"
)

func delete(ctx context.Context, d *schema.ResourceData, meta interface{}) diag.Diagnostics {
	input := expandDeleteNASSecurityGroupInput(d)
	svc := meta.(*client.Client).NAS
	_, err := svc.DeleteNASSecurityGroup(ctx, input)

	if err != nil {
		return diag.FromErr(fmt.Errorf("failed deleting NAS security group: %s", err))
	}

	d.SetId("")

	return nil
}
