---
page_title: "NIFCLOUD: nifcloud_ess_email_dkim"
subcategory: "ESS"
description: |-
  Provides an ESS domain DKIM generation resource.
---

# nifcloud_ess_email_dkim

Provides an ESS domain DKIM generation resource.

## Example Usage

```hcl
terraform {
  required_providers {
    nifcloud = {
      source = "nifcloud/nifcloud"
    }
  }
}

resource "nifcloud_ess_domain_identity" "example" {
  domain = "example.com"
}

resource "nifcloud_ess_domain_dkim" "example" {
  domain = nifcloud_ess_domain_identity.example.domain
}

resource "nifcloud_dns_record" "example" {
  count   = 3
  zone_id = "ABCDEFGHIJ123"
  name    = "${element(nifcloud_ess_domain_dkim.example.dkim_tokens, count.index)}._domainkey"
  type    = "CNAME"
  ttl     = "600"
  record  = "${element(nifcloud_ess_domain_dkim.example.dkim_tokens, count.index)}.dkim.ess.nifcloud.com"
}
```

## Argument Reference

The following arguments are supported:


* `domain` - (Required) Verified domain name to generate DKIM tokens for.

## Attributes Reference

In addition to the arguments listed above, the following computed attributes are exported:


* `dkim_tokens` - DKIM tokens generated by ESS. These tokens should be used to create CNAME records used to verify ESS Easy DKIM. 


## Import

nifcloud_ess_email_dkim can be imported using the `parameter corresponding to id`, e.g.

```
$ terraform import nifcloud_ess_email_dkim.example foo
```
